/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.custom.components;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.renderer.GlStateManager;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.mixin.client.gui.IGuiLabelMixin;
import noppes.npcs.api.wrapper.gui.CustomGuiLabelWrapper;
import noppes.npcs.client.gui.custom.GuiCustom;
import noppes.npcs.client.gui.custom.interfaces.IGuiComponent;

public class CustomGuiLabel
extends GuiLabel
implements IGuiComponent {
    int colour;
    String fullLabel;
    String[] hoverText;
    IItemStack hoverStack;
    GuiCustom parent;
    float scale = 1.0f;
    private boolean showShadow;
    private final int[] offsets;

    public static CustomGuiLabel fromComponent(CustomGuiLabelWrapper component) {
        CustomGuiLabel lbl = new CustomGuiLabel(component.getText(), component.getId(), component.getPosX(), component.getPosY(), component.getWidth(), component.getHeight(), component.getColor());
        lbl.showShadow = component.isShadow();
        lbl.setScale(component.getScale());
        if (component.hasHoverText()) {
            lbl.hoverText = component.getHoverText();
            lbl.hoverStack = component.getHoverStack();
        }
        return lbl;
    }

    public CustomGuiLabel(String label, int id, int x, int y, int width, int height, int colour) {
        super(Minecraft.func_71410_x().field_71466_p, id, GuiCustom.guiLeft + x, GuiCustom.guiTop + y, width, height, colour);
        this.fullLabel = label;
        this.colour = colour;
        this.showShadow = true;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        for (String s : fontRenderer.func_78271_c(label, width)) {
            this.func_175202_a(s);
        }
        this.offsets = new int[]{0, 0};
    }

    @Override
    public int getId() {
        return this.field_175204_i;
    }

    @Override
    public int[] getPosXY() {
        return new int[]{this.field_146162_g, this.field_146174_h};
    }

    @Override
    public void offSet(int offsetType, double[] windowSize) {
        switch (offsetType) {
            case 1: {
                this.offsets[0] = 0;
                this.offsets[1] = (int)windowSize[1];
                break;
            }
            case 2: {
                this.offsets[0] = (int)windowSize[0];
                this.offsets[1] = 0;
                break;
            }
            case 3: {
                this.offsets[0] = (int)windowSize[0];
                this.offsets[1] = (int)windowSize[1];
                break;
            }
            default: {
                this.offsets[0] = 0;
                this.offsets[1] = 0;
            }
        }
    }

    @Override
    public void onRender(Minecraft mc, int mouseX, int mouseY, int mouseWheel, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)0.0f);
        int x = this.offsets[0] == 0 ? this.field_146162_g : this.offsets[0] - this.field_146162_g - this.field_146167_a;
        int y = this.offsets[1] == 0 ? this.field_146174_h : this.offsets[1] - this.field_146174_h - this.field_146161_f;
        boolean hovered = mouseX >= x && mouseY >= y && mouseX < x + this.field_146167_a && mouseY < y + this.field_146161_f;
        GlStateManager.func_179109_b((float)(x - this.field_146162_g), (float)(y - this.field_146174_h), (float)Math.min(this.field_175204_i, 1000));
        if (this.showShadow) {
            this.func_146159_a(mc, mouseX, mouseY);
        } else if (this.field_146172_j) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            this.func_146160_b(mc, mouseX, mouseY);
            int border = ((IGuiLabelMixin)((Object)this)).npcs$getBorder();
            boolean centered = ((IGuiLabelMixin)((Object)this)).npcs$getCentered();
            List<String> labels = ((IGuiLabelMixin)((Object)this)).npcs$getLabels();
            int i = this.field_146174_h + this.field_146161_f / 2 + border / 2;
            int j = i - labels.size() * 10 / 2;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int k = 0; k < labels.size(); ++k) {
                if (centered) {
                    mc.field_71466_p.func_175065_a(labels.get(k), (float)this.field_146162_g + (float)(this.field_146167_a - mc.field_71466_p.func_78256_a(labels.get(k))) / 2.0f, (float)(j + k * 10), this.colour, false);
                    continue;
                }
                mc.field_71466_p.func_175065_a(labels.get(k), (float)this.field_146162_g, (float)(j + k * 10), this.colour, false);
            }
        }
        if (hovered) {
            if (this.hoverText != null && this.hoverText.length > 0) {
                this.parent.hoverText = this.hoverText;
            }
            if (this.hoverStack != null && !this.hoverStack.isEmpty()) {
                this.parent.hoverStack = this.hoverStack.getMCItemStack();
            }
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void setParent(GuiCustom parent) {
        this.parent = parent;
    }

    @Override
    public void setPosXY(int newX, int newY) {
        this.field_146162_g = newX;
        this.field_146174_h = newY;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    @Override
    public ICustomGuiComponent toComponent() {
        CustomGuiLabelWrapper component = new CustomGuiLabelWrapper(this.field_175204_i, this.fullLabel, this.field_146162_g, this.field_146174_h, this.field_146167_a, this.field_146161_f, this.colour);
        component.setShadow(this.showShadow);
        component.setHoverText(this.hoverText);
        return component;
    }
}

